unit [!UnitName];

interface

uses
  System.Collections, System.ComponentModel,
  System.Data, System.Drawing, System.Web, System.Web.SessionState,
  System.Web.UI, System.Web.UI.WebControls, System.Web.UI.HtmlControls,
  Borland.Eco.ObjectRepresentation,
  Borland.Eco.Web,
[!if=(EcoSpaceUnitName, "<NONE>")]
  Borland.Eco.Handles;
[!else]
  Borland.Eco.Handles, [!EcoSpaceUnitName], [!EcoPackageUnitName];
[!endif]

type
  T[!ClassName] = class(Borland.Eco.Web.AutoForm)
  {$REGION 'Designer Managed Code'}
  strict private
    procedure InitializeComponent;
  {$ENDREGION}
  strict private
    fEcoSpace: Borland.Eco.Handles.EcoSpace;
  strict protected
    PlaceHolder1: System.Web.UI.WebControls.PlaceHolder;
    procedure OnInit(e: EventArgs); override;
    function get_EcoSpace: Borland.Eco.Handles.EcoSpace; override;
    procedure RetrieveEcoSpace; override;
    procedure DoneWithEcoSpace; override;
    function get_ParentControl: Control; override; 

    property EcoSpace: Borland.Eco.Handles.EcoSpace read get_EcoSpace;
  end;

implementation

uses
  Borland.Eco.Services, EcoSpaceProvider;

{$REGION 'Designer Managed Code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure T[!ClassName].InitializeComponent;
begin
end;
{$ENDREGION}

procedure T[!ClassName].OnInit(e: EventArgs);
begin
  //
  // Required for Designer support
  //
  InitializeComponent;
  inherited OnInit(e);
end;

function T[!ClassName].get_EcoSpace: Borland.Eco.Handles.EcoSpace;
begin
  Result := fEcoSpace;
end;

procedure T[!ClassName].DoneWithEcoSpace;
begin
  if not Assigned(fEcoSpace) then
    Exit;

  TEcoSpaceProvider.ReturnEcoSpace(fEcoSpace);
  fEcoSpace := nil;
end;

procedure T[!ClassName].RetrieveEcoSpace;
begin
  if not Assigned(fEcoSpace) then
  begin
    fEcoSpace := TEcoSpaceProvider.GetEcoSpace;
    // Set additional root handles here and in DoneWithEcoSpace
  end;
end;

function T[!ClassName].get_ParentControl: Control;
begin
  result := PlaceHolder1;
end;

end.

